/**
* \file: InputSourceReport.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: M. Adachi / ADITJ/SW / madachi@jp.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_IINPUTADAPTER_H
#define AAUTO_IINPUTADAPTER_H

#include <pthread_adit.h>
#include <atomic>
#include <map>
#include <aauto/InputSource.h>

namespace adit { namespace aauto
{

enum WaylandDeviceType
{
    AutoDetectType        = 1,
    PointerDeviceType     = 2,
    SingleTouchDeviceType = 3,
    MultiTouchDeviceType  = 4
};
const int WaylandDeviceTypeFirst = (int)AutoDetectType;
const int WaylandDeviceTypeLast  = (int)MultiTouchDeviceType;

enum TouchActionType
{
     TActionDown = 0,
     TActionUp,
     TActionMotion
};

enum KeyActionType
{
     KActionDown = 0,
     KActionUp
};

struct InputSourceTouch
{
    uint32_t        pointerIds;
    double          x;
    double          y;
    TouchActionType action;
};

struct InputSourceKey
{
    uint64_t        timestamp;
    uint16_t        code;
    KeyActionType   action;
};

struct Pointer
{
    uint32_t x;
    uint32_t y;
};

#define NSEC_PER_SEC    (1000ULL * 1000ULL * 1000ULL)
class InputReport
{
public:
     InputReport();
     ~InputReport();

     bool SendInput();
     void setTouch(uint32_t id, double x, double y, TouchActionType action);
     void initialize(InputSource* inInputSource, int touchWidth, int touchHeight, int inMarginX, int inMarginY);
     bool shutdown();

private:
     bool SendInputReport(int action, int id);
     InputSource*        inputSource;
     InputSourceTouch    touch;
     InputSourceKey      key;
     int                 width;
     int                 height;
     int                 marginX;
     int                 marginY;

     // pointers table
     std::map<int, Pointer> mTrackedPointers;
     std::atomic<bool>  mRunning;
     /* the mutex object to lock shutdown and reportTouch */
     pthread_mutex_t mInputReportMutex;
};

} } /* namespace adit { namespace aauto */

#endif /* AAUTO_IINPUTADAPTER_H */
